#include "block_type.h"
#include "render.h"
LandArray * block_types;
static void fill_in(void);
BlockType* blocktype_new(char const * name, float xs, float ys, float zs, void(* tick)(Block *), bool(* touch)(Block *, Block *, float, float, float), void(* destroy)(Block *), Block * (* allocate)(void), void(* post_init)(Block *)) {
    BlockType * self;
    land_alloc(self);
    self->name = land_strdup(name);
    self->xs = xs;
    self->ys = ys;
    self->zs = zs;
    self->dynamic = 0;
    self->lift = 0;
    self->transparent = 0;
    self->tick = tick;
    self->touch = touch;
    self->destroy = destroy;
    self->allocate = allocate;
    self->post_init = post_init;
    return self;
}
void blocktype_destroy(BlockType * self) {
    if (! self) {
        return ;
    }
    if (self->bitmaps) {
        {
            LandArrayIterator __iter0__ = LandArrayIterator_first(self->bitmaps);
            for (LandImage * pic = LandArrayIterator_item(self->bitmaps, &__iter0__); LandArrayIterator_next(self->bitmaps, &__iter0__); pic = LandArrayIterator_item(self->bitmaps, &__iter0__)) {
                land_image_destroy(pic);
            }
        }
        land_array_destroy(self->bitmaps);
    }
    land_free(self);
}
bool blocktype_preload(BlockType * self) {
    {
        LandArrayIterator __iter0__ = LandArrayIterator_first(self->bitmaps);
        for (LandImage * pic = LandArrayIterator_item(self->bitmaps, &__iter0__); LandArrayIterator_next(self->bitmaps, &__iter0__); pic = LandArrayIterator_item(self->bitmaps, &__iter0__)) {
            if (land_image_load_on_demand(pic)) {
                return 1;
            }
        }
    }
    return 0;
}
static BlockType * block_types_flowers [8];
static void fill_in(void) {
    block_types_flowers [1] = NULL;
}
int block_type_flower(BlockType * self) {
    fill_in();
    for (int i = 1; i < 8; i += 1) {
        if (self == block_types_flowers [i]) {
            return i;
        }
    }
    return 0;
}
BlockType* block_flower(int i) {
    fill_in();
    return block_types_flowers [i];
}
BlockType* block_type_by_name(str name) {
    {
        LandArrayIterator __iter0__ = LandArrayIterator_first(block_types);
        for (BlockType * bt = LandArrayIterator_item(block_types, &__iter0__); LandArrayIterator_next(block_types, &__iter0__); bt = LandArrayIterator_item(block_types, &__iter0__)) {
            if (land_equals(bt->name, name)) {
                return bt;
            }
        }
    }
    return NULL;
}
